<?php
/* --------------------------------------------------------------
   ParcelServiceCriteria.php 2020-02-10
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\ParcelService\SqlCriteria;

use Gambio\Admin\ParcelService\Interfaces\ParcelServiceSqlCriteria as ParcelServiceSqlCriteriaInterface;
use Gambio\Core\Criteria\AbstractSqlCriteria;

/**
 * Class ParcelServiceRestApiCriteria
 *
 * @package Gambio\Admin\ParcelService\SqlCriteria
 */
class ParcelServiceSqlCriteria extends AbstractSqlCriteria implements ParcelServiceSqlCriteriaInterface
{
    /**
     * ParcelServiceSqlCriteria constructor.
     *
     * @param ParcelServiceFilters  $filters
     * @param ParcelServiceSortings $sortings
     */
    private function __construct(ParcelServiceFilters $filters, ParcelServiceSortings $sortings)
    {
        $this->filters  = $filters;
        $this->sortings = $sortings;
    }
    
    
    /**
     * @param ParcelServiceFilters  $filters
     * @param ParcelServiceSortings $sortings
     *
     * @return ParcelServiceSqlCriteria
     */
    public static function create(
        ParcelServiceFilters $filters,
        ParcelServiceSortings $sortings
    ): ParcelServiceSqlCriteria {
        return new self($filters, $sortings);
    }
}